#version 330
#extension GL_EXT_gpu_shader4 : enable
//inward spikes and slow rotationMod01.fsh  by  HaleyHalcyon 

//https://www.shadertoy.com/view/tlscz7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float smootherstep(float edge0, float edge1, float x) {
  // Scale, and clamp x to 0..1 range
  x = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
  // Evaluate polynomial
  return x * x * x * (x * (x * 6. - 15.) + 10.);
}

float softsquare(float x) {
    float x2 = abs(2. * fract(x) - 1.);
    return smoothstep(0.1, 0.9, x2);
}

float trapezoid(float x) {
    x = fract(x);
    if (x < 0.25) {
        return 4.0 * x;
    } else if (x < 0.5) {
        return 1.;
    } else if (x < 0.75) {
        return -4.0 * x + 3.0;
    } else {
        return 0.;
    }
}

vec3 gradient(float y) {
    vec3 x = trapezoid(y) * vec3(1.0, 0.0, 0.0)
           + trapezoid(y - 0.25) * vec3(0.0, 1.0, 1.0);
    return x;
}

float spikes(float x) {
    x = 1. - abs(sin(x));
    return x * x;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    float time = fract(iTime / 12.);
    const float PI = 3.14159265;
    float hue = time * 2. * PI;
    
    // Normalized pixel coordinates (from 0 to 1)
    float scale = distance(iResolution.x, iResolution.y);
    vec2 uv = gl_FragCoord.xy / scale;
	uv -= vec2(iResolution.x / scale, iResolution.y / scale) / 2.;
    uv *= 2.0;
    
    float dist = log(uv.x*uv.x+uv.y*uv.y + 0.10) * 1.25;
    float angle = atan(uv.y, uv.x);
    const float spokes = float(17) / 2.;
    const float spokes2 = float(55) / 2.;
    
    float s1 = spikes(angle * spokes - time * 2. * PI);
    float s2 = spikes(angle * spokes2 + time * 2. * PI);
    float und = sin(angle + time * 2. * PI + 0.5 * dist);
    
    vec3 color = gradient(
        dist
        + (0.3 + 0.1 * sin(2. * time * PI)) * s1
        + (0.025 * (2. + sin(2. * time * PI + angle))) * s2
        + 0.15 * und
    );
    // Output to screen
    gl_FragColor = vec4(
        color,
        1
    );
}